package com.qboxus.tictic.activitesfragments.videorecording

import android.app.Dialog
import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast
import androidx.core.content.ContextCompat
import androidx.databinding.DataBindingUtil
import com.google.android.material.bottomsheet.BottomSheetBehavior
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.qboxus.tictic.Constants
import com.qboxus.tictic.R
import com.qboxus.tictic.activitesfragments.accounts.AccountUtils
import com.qboxus.tictic.activitesfragments.accounts.EmailPhoneFragment
import com.qboxus.tictic.activitesfragments.livestreaming.activities.ConcertSelectionA
import com.qboxus.tictic.activitesfragments.shoping.AddProducts.ListProducts
import com.qboxus.tictic.apiclasses.ApiLinks
import com.qboxus.tictic.databinding.FragmentVideoCreationBinding
import com.qboxus.tictic.interfaces.FragmentCallBack
import com.qboxus.tictic.models.UserRegisterModel
import com.qboxus.tictic.simpleclasses.DateOprations
import com.qboxus.tictic.simpleclasses.Dialogs
import com.qboxus.tictic.simpleclasses.Functions.cancelLoader
import com.qboxus.tictic.simpleclasses.Functions.checkStatus
import com.qboxus.tictic.simpleclasses.Functions.getHeaders
import com.qboxus.tictic.simpleclasses.Functions.getSharedPreference
import com.qboxus.tictic.simpleclasses.Functions.isOpenGLVersionSupported
import com.qboxus.tictic.simpleclasses.Functions.isWorkManagerRunning
import com.qboxus.tictic.simpleclasses.Functions.showLoader
import com.qboxus.tictic.simpleclasses.Variables
import com.volley.plus.VPackages.VolleyRequest
import org.json.JSONObject

class CreateContentFragment(var fragmentCallBack: FragmentCallBack) : BottomSheetDialogFragment(), View.OnClickListener {


    var streamingId = ""
    private var mBehavior: BottomSheetBehavior<*>? = null

    lateinit var binding:FragmentVideoCreationBinding
    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        val dialog = super.onCreateDialog(savedInstanceState) as BottomSheetDialog
        val view = View.inflate(getContext(), R.layout.fragment_video_creation, null)
        dialog.setContentView(view)
        mBehavior = BottomSheetBehavior.from(view.parent as View)
        return dialog
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        binding =DataBindingUtil.inflate(inflater,R.layout.fragment_video_creation, container, false)
        binding.goBack.setOnClickListener(this)
        binding.postArgearLayout.setOnClickListener(this)
        binding.liveLayout.setOnClickListener(this)
        binding.createDish.visibility = View.VISIBLE
        binding.createDish.setOnClickListener(this)
        return binding.root
    }

    override fun onStart() {
        super.onStart()
        mBehavior!!.state = BottomSheetBehavior.STATE_EXPANDED
    }

    override fun onClick(v: View) {
        when (v.id) {
            R.id.live_layout -> {
                liveStreamingId
            }

            R.id.goBack -> dismiss()
            R.id.post_argear_layout -> {
                val isOpenGLSupported = isOpenGLVersionSupported(context, 0x00030001)
                if (isOpenGLSupported) {
                    openVideoCamera()
                } else {
                    Toast.makeText(
                        binding.root.context,
                       requireContext().getString(R.string.your_device_opengl_verison_is_not_compatible_to_use_this_feature),
                        Toast.LENGTH_SHORT
                    ).show()
                }
            }


            R.id.createDish -> {
                    dismiss()

                    val intent = Intent(context, ListProducts::class.java)
                    startActivity(intent)
                    requireActivity().overridePendingTransition(R.anim.in_from_bottom, R.anim.out_to_top)

            }

        }
    }


    private fun openRegisterBussinessScreen() {
        val userRegisterModel=UserRegisterModel()
        val nextF = EmailPhoneFragment.newInstance(AccountUtils.typeSignUp,true, userRegisterModel)
        val transaction = requireActivity().supportFragmentManager.beginTransaction()
        transaction.setCustomAnimations(
            R.anim.in_from_right,
            R.anim.out_to_left,
            R.anim.in_from_left,
            R.anim.out_to_right)
        transaction.addToBackStack(null)
        transaction.replace(R.id.mainMenuFragment, nextF, AccountUtils.typeLogin).addToBackStack(null)
            .commit()
    }

    fun openVideoCamera() {
        if (isWorkManagerRunning(requireContext(), "videoUpload")) {
            Toast.makeText(
                binding.root.context,
                requireContext().getString(R.string.video_already_in_progress),
                Toast.LENGTH_SHORT
            ).show()
            Dialogs.showAlert(
                activity,
                requireContext().getString(R.string.app_name),
                requireContext().getString(R.string.video_already_in_progress)
            )
        } else {
            dismiss()
            val intent = Intent(binding.root.context, VideoRecoderActivity::class.java)
            startActivity(intent)
            requireActivity().overridePendingTransition(R.anim.in_from_bottom, R.anim.out_to_top)
        }
    }

    private val liveStreamingId: Unit
        private get() {
            val parameters = JSONObject()
            try {
                parameters.put(
                    "user_id",
                    getSharedPreference(binding.root.context).getString(Variables.U_ID, "0")
                )
                parameters.put("started_at", DateOprations.getCurrentDate("yyyy-MM-dd HH:mm:ss"))
            } catch (e: Exception) {
                e.printStackTrace()
            }
            showLoader(activity, false, false)
            VolleyRequest.JsonPostRequest(
                activity,
                ApiLinks.liveStream,
                parameters,
                getHeaders(binding.root.context)
            ) { resp ->
                checkStatus(activity, resp)
                cancelLoader()
                try {
                    val jsonObject = JSONObject(resp)
                    val code = jsonObject.optString("code")
                    if (code == "200") {
                        val msgObj = jsonObject.getJSONObject("msg")
                        val streamingObj = msgObj.getJSONObject("LiveStreaming")
                        streamingId = streamingObj.optString("id")
                        gotoRoleActivity()
                    }
                } catch (e: Exception) {
                    Log.d(Constants.tag, "Exception : $e")
                }
            }
        }

    fun gotoRoleActivity() {

        val intent = Intent(activity, ConcertSelectionA::class.java)
        intent.putExtra("userId", getSharedPreference(context).getString(Variables.U_ID, ""))
        intent.putExtra("userName", getSharedPreference(context).getString(Variables.U_NAME, ""))
        intent.putExtra("userPicture", getSharedPreference(context).getString(Variables.U_PIC, ""))
        intent.putExtra("userRole", io.agora.rtc2.Constants.CLIENT_ROLE_BROADCASTER)
        intent.putExtra("streamingId", streamingId)
        startActivity(intent)
        requireActivity().overridePendingTransition(R.anim.in_from_bottom, R.anim.out_to_top)

//        val intent = Intent()
//        intent.putExtra("userId", getSharedPreference(binding.root.context).getString(Variables.U_ID, ""))
//        intent.putExtra("userName", getSharedPreference(binding.root.context).getString(Variables.U_NAME, ""))
//        intent.putExtra("userPicture", getSharedPreference(binding.root.context).getString(Variables.U_PIC, ""))
//        intent.putExtra("userRole", io.agora.rtc2.Constants.CLIENT_ROLE_BROADCASTER)
//        intent.putExtra("description", "")
//        intent.putExtra("secureCode", "")
//        intent.putExtra("streamingId", streamingId)
//        intent.putExtra("joinStreamPrice", 0)
//        intent.putExtra(
//            com.qboxus.tictic.activitesfragments.livestreaming.Constants.KEY_CLIENT_ROLE,
//            io.agora.rtc2.Constants.CLIENT_ROLE_BROADCASTER
//        )
//        val ticTicApp = requireActivity().application as TicTicApp
//        ticTicApp.engineConfig().uid =
//            getSharedPreference(binding.root.context).getString(Variables.U_ID, "")
//        ticTicApp.engineConfig().channelName = streamingId
//        intent.putExtra("dualStreaming", true)
//        intent.putExtra("onlineType", "multicast")
//        intent.setClass(requireActivity(), MulticastStreamerActivity::class.java)
//        dismiss()
//        startActivity(intent)

    }
}